ORCA/M Asm65816 2.1.0

0001 B747                       TITLE ', JUMP.a - JumpLoad'
0002 B747              *
0003 B747              ****************************************************************
0004 B747              *
0005 B747              *              Jump Table Load ($15)
0006 B747              *
0007 B747              *  Inputs:     UserID (2 bytes)
0008 B747              *              Load File Number (2 bytes)
0009 B747              *              Load Segment Number (2 bytes)
0010 B747              *              Load Segment Offset (4 bytes)
0011 B747              *
0012 B747              *              inputs are 'not' on stack but can found by tracing
0013 B747              *              the return address back to the calling location.  They
0014 B747              *              are in locations before the JSL.
0015 B747              *
0016 B747              *  Outputs:    none
0017 B747              *  Errors:     $0000 - Operation successful
0018 B747              *              $1101 - Segment not found
0019 B747              *              $1102 - Segment not dynamic
0020 B747              *              $1104 - File not Load File
0021 B747              *              $00xx - ProDOS I/O error
0022 B747              *              $02xx - Memory Manager error
0023 B747              *
0024 B747              ****************************************************************
0025 B747              *
0026 B747              JumpLoad PROC 
0027 B747                       LoadSegCheck 
0028 B747
0029 B747                       with DirectPage, Globals
0030 B747                       Import reset_local_mark,find_user_id,merge_path_2, \
0031 B747                       lock_segment,open_load_file,error_routine,  \ 
0032 B747                       lock_handles,unlock_handles,load_segment,  \ 
0033 B747                       Process_Reloc,close_load_file 
0034 B747              ;
0035 B747              ;       the stack looks like this at entry:
0036 B747              ;
0037 B747              ;       (previous contents)
0038 B747              ;       return to Jump Table entry              (3 bytes)
0039 B747              ;       top of stack
0040 B747              ;
0041 B747 08                    php                            ;save user's P-register
0042 B748 8B                    phb                            ;save user's DBR
0043 B749 4B                    phk                            ;set to our bank
0044 B74A AB                    plb   
0045 B74B              ;
0046 B74B              ;       Now, the stack looks like this:
0047 B74B              ;
0048 B74B              ;       (previous contents)
0049 B74B              ;       return  to Jump Table entry             (3 bytes)
0050 B74B              ;       user's processor status                 (1 byte)
0051 B74B              ;       user's Data Bank Register               (1 byte)
0052 B74B              ;       top of stack
0053 B74B              ;
0054 B74B C2 30                 rep   #$30                     ;ensure 16-bit mode
0055 B74D
0056 B74D 8D A0 A6              sta   save_a
0057 B750 8E A2 A6              stx   save_x
0058 B753 8C A4 A6              sty   save_y                   ;save app's registers
0059 B756
0060 B756 FA                    plx                            ;get the processor status + Bank register
0061 B757 68                    pla                            ;get the low word of the return address
0062 B758 8D A6 A6              sta   starting_addr
0063 B75B
0064 B75B E2 20                 sep   #$20                     ;8 bit mode
0065 B75D 68                    pla   
0066 B75E 8D A8 A6              sta   starting_addr+2          ;store the bank byte of the return address
0067 B761 9C A9 A6              stz   starting_addr+3
0068 B764 C2 20                 rep   #$20                     ;16 bit
0069 B766 DA                    phx                            ;put status and DBR back on stack
0070 B767
0071 B767 0B                    phd                            ;save user's direct page
0072 B768 AD 92 A6              lda   my_dir_page              ;set to my direct page
0073 B76B 5B                    tcd   
0074 B76C
0075 B76C              ;
0076 B76C              ;       Now, the stack looks like this:
0077 B76C              ;
0078 B76C              ;       (previous contents)
0079 B76C              ;       user's processor status                 (1 byte)
0080 B76C              ;       user's Data Bank Register               (1 byte)
0081 B76C              ;       user's Direct Register                  (2 bytes)
0082 B76C              ;       top of stack
0083 B76C
0084 B76C 22 64 00 E1           jsl   incbusyflg
0085 B770
0086 B770 E2 20                 sep   #$20                     ;8-bit mode
0087 B772 AF 68 C0 E0           lda   >statereg                ;get current value
0088 B776 85 D2                 sta   save_statereg
0089 B778 AF 8B C0 E0           lda   >$E0C08B                 ;shift in language-card memory
0090 B77C AF 8B C0 E0           lda   >$E0C08B
0091 B780 C2 20                 rep   #$20                     ;back to 16-bit mode
0092 B782
0093 B782              ; Now that we've saved the user's environment, we can get down to the real work
0094 B782
0095 B782 20 C0 D1              jsr   reset_local_mark
0096 B785
0097 B785 38                    sec   
0098 B786 AD A6 A6              lda   starting_addr            ;build a pointer to the start of the info
0099 B789 E9 0D 00              sbc   #jmp_entry_size-1
0100 B78C 85 8C                 sta   jmp_tbl_ptr
0101 B78E AD A8 A6              lda   starting_addr+2
0102 B791 E9 00 00              sbc   #$0000
0103 B794 85 8E                 sta   jmp_tbl_ptr+2            ;temp_ptr points to Jump Table Entry
0104 B796
0105 B796 A7 8C                 lda   [jmp_tbl_ptr]            ;get the user ID
0106 B798 8D B6 A6              sta   |USERID                  ;update the global User ID
0107 B79B 20 67 D4              jsr   find_user_id
0108 B79E 90 03                 bcc   @found_it
0109 B7A0              @do_old_loader  
0110 B7A0 4C C7 B8              jmp   old_loader               ;not ExpressLoad's file
0111 B7A3              @found_it  
0112 B7A3 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle  ;get handle to the ExpressLoad segment
0113 B7A6 B7 62                 lda   [temp_ptr],y
0114 B7A8 85 88                 sta   ExpressHandle
0115 B7AA C8                    iny   
0116 B7AB C8                    iny   
0117 B7AC B7 62                 lda   [temp_ptr],y
0118 B7AE 85 8A                 sta   ExpressHandle+2
0119 B7B0
0120 B7B0 A0 02 00              ldy   #JE_FileNum              ;check the load file number
0121 B7B3 B7 8C                 lda   [jmp_tbl_ptr],y
0122 B7B5 3A                    dec   a
0123 B7B6 D0 E8                 bne   @do_old_loader           ;This file is not ExpressLoad compatible
0124 B7B8 C8                    iny   
0125 B7B9 C8                    iny   
0126 B7BA B7 8C                 lda   [jmp_tbl_ptr],y          ;get the segment we need to find
0127 B7BC 85 AC                 sta   search_seg
0128 B7BE
0129 B7BE C8                    iny   
0130 B7BF C8                    iny   
0131 B7C0 B7 8C                 lda   [jmp_tbl_ptr],y          ;get the relative offset
0132 B7C2 85 AE                 sta   jmp_patch_value
0133 B7C4 C8                    iny   
0134 B7C5 C8                    iny   
0135 B7C6 B7 8C                 lda   [jmp_tbl_ptr],y
0136 B7C8 85 B0                 sta   jmp_patch_value+2
0137 B7CA
0138 B7CA 20 4A D3              jsr   merge_path_2
0139 B7CD
0140 B7CD 18                    clc   
0141 B7CE A0 02 00              ldy   #$0002
0142 B7D1 A7 88                 lda   [ExpressHandle]
0143 B7D3 69 04 00              adc   #ExpressloadSeg.SegCount ;pass the link field
0144 B7D6 85 3E                 sta   HET_ptr                  ;header entry table pointer
0145 B7D8 B7 88                 lda   [ExpressHandle],y
0146 B7DA 69 00 00              adc   #$0000
0147 B7DD 85 40                 sta   HET_ptr+2
0148 B7DF
0149 B7DF A5 AC                 lda   search_seg
0150 B7E1 3A                    dec   a                        ;convert base 1 to base 0
0151 B7E2 3A                    dec   a                        ;allow for ExpressLoad segment
0152 B7E3
0153 B7E3 0A                    asl   a
0154 B7E4 0A                    asl   a
0155 B7E5 0A                    asl   a                        ;times 8 for HET entry size
0156 B7E6
0157 B7E6 1A                    inc   a                        ;add two to pass the segment count field
0158 B7E7 1A                    inc   a
0159 B7E8
0160 B7E8 18                    clc   
0161 B7E9 65 3E                 adc   HET_ptr                  ;make a pointer to the Entry
0162 B7EB 85 42                 sta   HET_entry_ptr            ;pointer to the entry itself
0163 B7ED A9 00 00              lda   #$0000
0164 B7F0 65 40                 adc   HET_ptr+2
0165 B7F2 85 44                 sta   HET_entry_ptr+2
0166 B7F4              ;
0167 B7F4              ;Build a pointer to the segment header itself
0168 B7F4              ;
0169 B7F4 18                    clc   
0170 B7F5 A5 42                 lda   HET_entry_ptr            ;add in relative address to segment
0171 B7F7 67 42                 adc   [HET_entry_ptr]
0172 B7F9 85 4E                 sta   seg_header_ptr
0173 B7FB A5 44                 lda   HET_entry_ptr+2
0174 B7FD 69 00 00              adc   #$0000
0175 B800 85 50                 sta   seg_header_ptr+2
0176 B802              ;
0177 B802              ;Now lets see if the segment is already loaded into memory
0178 B802              ;
0179 B802 A0 02 00              ldy   #HET_Entry.SegFlags
0180 B805 B7 42                 lda   [HET_entry_ptr],y
0181 B807 10 24                 bpl   @new_segment             ;we must load the segment from disk
0182 B809 4A                    lsr   a                        ;see if the segment is marked as purgable
0183 B80A 90 07                 bcc   @its_locked
0184 B80C A5 AC                 lda   search_seg               ;pass in the segment number please
0185 B80E 20 06 E1              jsr   lock_segment             ;go and lock this segment
0186 B811 B0 1A                 bcs   @new_segment             ;we have to reload the segment from disk
0187 B813              @its_locked  
0188 B813 A0 04 00              ldy   #HET_Entry.SegHandle     ;get the base address
0189 B816 B7 42                 lda   [HET_entry_ptr],y
0190 B818 85 46                 sta   temp_handle
0191 B81A C8                    iny   
0192 B81B C8                    iny   
0193 B81C B7 42                 lda   [HET_entry_ptr],y
0194 B81E 85 48                 sta   temp_handle+2
0195 B820
0196 B820 A0 02 00              ldy   #$0002                   ;get the real address
0197 B823 A7 46                 lda   [temp_handle]
0198 B825 85 4A                 sta   base_ptr
0199 B827 B7 46                 lda   [temp_handle],y
0200 B829 85 4C                 sta   base_ptr+2
0201 B82B 80 57                 bra   @do_patch
0202 B82D              @new_segment  
0203 B82D 20 69 DD              jsr   open_load_file           ;open the puppy
0204 B830 90 03                 bcc   @got_it
0205 B832              @oops     
0206 B832 20 20 D2              jsr   error_routine            ;sorry no can do. (No Return)
0207 B835              @got_it   
0208 B835 A9 01 00              lda   #1
0209 B838 8D 72 A7              sta   PSysPrefs.pCount
0210 B83B
0211 B83B 20 62 BA              jsr   lock_handles
0212 B83E 22 A8 00 E1           jsl   $e100a8                  ;get the current system preferences
0213 B842 0F 20                 DC W:GetSysPrefs
0214 B844 72 A7 01 00           DC L:PSysPrefs
0215 B848              ;
0216 B848              ;Save the current user's preference please
0217 B848              ;
0218 B848 AD 74 A7              lda   PSysPrefs.preferences
0219 B84B 8D 9E A6              sta   users_prefs
0220 B84E              ;
0221 B84E              ;Now ask the operating system to put up a mount dialog when I ask for a disk
0222 B84E              ;
0223 B84E A9 00 C0              lda   #$C000                   ;ask the OS to put up the mount dialog
0224 B851 8D 74 A7              sta   PSysPrefs.preferences
0225 B854
0226 B854 22 A8 00 E1           jsl   $e100a8
0227 B858 0C 20                 DC W:SetSysPrefs               ;set the system preference
0228 B85A 72 A7 01 00           DC L:PSysPrefs
0229 B85E 20 CB BA              jsr   unlock_handles
0230 B861
0231 B861 20 75 E1              jsr   load_segment             ;load the segment into memory
0232 B864 B0 CC                 bcs   @oops
0233 B866 A5 AC                 lda   search_seg               ;relocate the segment
0234 B868 20 05 D6              jsr   Process_Reloc
0235 B86B
0236 B86B AD 9E A6              lda   users_prefs
0237 B86E 8D 74 A7              sta   PSysPrefs.preferences
0238 B871 20 62 BA              jsr   lock_handles
0239 B874 22 A8 00 E1           jsl   $e100a8
0240 B878 0C 20                 DC W:SetSysPrefs               ;restore the caller's system preference
0241 B87A 72 A7 01 00           DC L:PSysPrefs
0242 B87E 20 CB BA              jsr   unlock_handles
0243 B881
0244 B881 20 2E DD              jsr   close_load_file          ;close the file
0245 B884              @do_patch  
0246 B884 18                    clc                            ;add in the offset field
0247 B885 A5 4A                 lda   base_ptr
0248 B887 65 AE                 adc   jmp_patch_value
0249 B889 85 4A                 sta   base_ptr
0250 B88B A5 4C                 lda   base_ptr+2
0251 B88D 65 B0                 adc   jmp_patch_value+2
0252 B88F 85 4C                 sta   base_ptr+2
0253 B891
0254 B891              back_to_user  
0255 B891 A0 0A 00              ldy   #JE_jsl                  ;offset to the JSL
0256 B894 A9 5C 00              lda   #$5C                     ;convert to a JML
0257 B897 97 8C                 sta   [jmp_tbl_ptr],y
0258 B899 C8                    iny   
0259 B89A A5 4A                 lda   base_ptr
0260 B89C 97 8C                 sta   [jmp_tbl_ptr],y
0261 B89E 8D C4 B8              sta   call_routine+1
0262 B8A1 A5 4B                 lda   base_ptr+1
0263 B8A3 C8                    iny   
0264 B8A4 97 8C                 sta   [jmp_tbl_ptr],y
0265 B8A6 8D C5 B8              sta   call_routine+2
0266 B8A9
0267 B8A9              ;
0268 B8A9              ; Restore user's machine state and jump to the just-loaded routine
0269 B8A9              ;
0270 B8A9 E2 20                 sep   #$20
0271 B8AB A5 D2                 lda   save_statereg            ;restore original language card settings
0272 B8AD 8F 68 C0 E0           sta   >statereg
0273 B8B1 C2 20                 rep   #$20
0274 B8B3
0275 B8B3 22 68 00 E1           jsl   decbusyflg
0276 B8B7 2B                    pld                            ;restore Direct Register
0277 B8B8 AD A0 A6              lda   save_a                   ;restore registers
0278 B8BB AE A2 A6              ldx   save_x
0279 B8BE AC A4 A6              ldy   save_y
0280 B8C1 AB                    plb   
0281 B8C2 28                    plp                            ;restore processor mode
0282 B8C3 5C B0 D2 06  call_routine jml   $0000000             ;call the desired routine
0283 B8C7
0284 B8C7              old_loader  
0285 B8C7              ;
0286 B8C7              ;        set System Preferences to Display Mount Dialogs
0287 B8C7              ;
0288 B8C7 A9 01 00              lda   #1
0289 B8CA 8D 72 A7              sta   PSysPrefs.pCount
0290 B8CD 22 A8 00 E1           jsl   $E100A8
0291 B8D1 0F 20                 DC W:GetSysPrefs
0292 B8D3 72 A7 01 00           DC L:PSysPrefs                 ;get original preferences
0293 B8D7 AD 74 A7              lda   PSysPrefs.preferences    ;save original preferences
0294 B8DA 48                    pha   
0295 B8DB A9 00 C0              lda   #$C000                   ;set to show dialog w/o cancel button
0296 B8DE 8D 74 A7              sta   PSysPrefs.preferences
0297 B8E1 22 A8 00 E1           jsl   $E100A8
0298 B8E5 0C 20                 DC W:SetSysPrefs
0299 B8E7 72 A7 01 00           DC L:PSysPrefs                 ;set new preferences
0300 B8EB 68                    pla   
0301 B8EC 8D 74 A7              sta   PSysPrefs.preferences    ;restore original preferences
0302 B8EF              ;
0303 B8EF              ;        call Load Dynamic Segment routine
0304 B8EF              ;
0305 B8EF A9 00 00              lda   #0                       ;output Address
0306 B8F2 48                    pha   
0307 B8F3 48                    pha   
0308 B8F4 A7 8C                 lda   [jmp_tbl_ptr]            ;UserID
0309 B8F6 48                    pha   
0310 B8F7 A0 02 00              ldy   #JE_FileNum
0311 B8FA B7 8C                 lda   [jmp_tbl_ptr],y          ;File Number
0312 B8FC 48                    pha   
0313 B8FD A0 04 00              ldy   #JE_SegNum
0314 B900 B7 8C                 lda   [jmp_tbl_ptr],y          ;Segment Number
0315 B902 48                    pha   
0316 B903 20 2A E6              jsr   Load_Segment
0317 B906 FA                    plx   
0318 B907 7A                    ply   
0319 B908 86 04                 stx   TempZero+4               ;address of Dynamic Segment
0320 B90A 84 06                 sty   TempZero+6
0321 B90C 08                    php                            ;save carry and error code
0322 B90D 48                    pha   
0323 B90E              ;
0324 B90E              ;        restore original System Preferences
0325 B90E              ;
0326 B90E 22 A8 00 E1           jsl   $E100A8
0327 B912 0C 20                 DC W:SetSysPrefs
0328 B914 72 A7 01 00           DC L:PSysPrefs                 ;set preferences
0329 B918
0330 B918 68                    pla                            ;restore error code
0331 B919 28                    plp                            ;and carry
0332 B91A B0 14                 bcs   error                    ;was there an error?
0333 B91C              ;
0334 B91C              ;        calculate address of Dynamic Segment function
0335 B91C              ;
0336 B91C A0 06 00              ldy   #JE_Offset
0337 B91F B7 8C                 lda   [jmp_tbl_ptr],y
0338 B921 18                    clc   
0339 B922 65 04                 adc   TempZero+4
0340 B924 85 4A                 sta   base_ptr
0341 B926 A5 06                 lda   TempZero+6
0342 B928 69 00 00              adc   #0
0343 B92B 85 4C                 sta   base_ptr+2
0344 B92D 4C 91 B8              jmp   back_to_user             ;now off to the routine
0345 B930
0346 B930 48           error    pha                            ;error code
0347 B931 A9 00 00              lda   #0                       ;no message
0348 B934 48                    pha   
0349 B935 48                    pha   
0350 B936 A2 03 15 22           _SysFailMgr 
0351 B93D
0352 B93D                       ENDP 
0353 B93D
